//
//  OPItem+Copying.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2016-07-07.
//
//

#import "OPItem.h"

typedef NS_ENUM(NSInteger, OPItemCopyRequirement) {
	OPItemCopyRequirementNone = 0,
	OPItemCopyRequirementUpdateSigningKeys = 1, // can be copied if you update the file reference signing keys first
	OPItemCopyRequirementUnsupported = 2, // there's nothing you can do to make this happen, don't try
};

@interface OPItem (Copying)

- (OPItemCopyRequirement)requirementForCopyingFromProfile:(id<OPGenericProfile>)originatingProfile toProfile:(id<OPGenericProfile>)destinationProfile;

@end
